/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.TracePrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class Trace {
    public static final int DEBUG = 3;
    public static final int FDEBUG = 2;
    public static final int TRACE = 1;
    public static final int LEVEL = 3;
    public static final String STD = "!STD";
    private static Object objectDumper = null;
    private static Method dumpObject = null;
    private static Object[] dumpObjectArgs = new Object[2];
    private static TracePrintStream printStream = null;
    private static boolean isLibraryLoaded = false;
    private static boolean isObjectDumperAvailable = false;
    private static boolean areServletClassesAvailable;
    private static boolean areJSPClassesAvailable;
    private static String printStreamName;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$util$ObjectDumperAttributes;

    public static void trace(String traceMask, String prefix, Object trace, ObjectDumperAttributes attribs) {
        if (traceMask == null || traceMask.length() < 8) {
            Trace.trace("XFRMTRCF: !!!!!!INVALID TRACE MASK!!!!!!!!: " + traceMask);
            traceMask = "XFRMTRCF";
        } else {
            char level = (traceMask = traceMask.toUpperCase()).charAt(7);
            if (level != 'T' && level != 'F' && level != 'D' && level != 'L') {
                Trace.trace("XFRMTRCF: !!!!!!INVALID TRACE LEVEL!!!!!!!!: " + traceMask);
                traceMask = "XFRMTRCF";
            }
        }
        if (trace != null) {
            if (prefix == null) {
                prefix = "";
            }
            String formattedTrace = null;
            if (trace instanceof String) {
                formattedTrace = (String)trace;
            } else if (trace instanceof Throwable) {
                Throwable currentTrace = (Throwable)trace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                while (currentTrace != null) {
                    currentTrace.printStackTrace(printWriter);
                    if (areServletClassesAvailable && currentTrace instanceof ServletException) {
                        currentTrace = ((ServletException)currentTrace).getRootCause();
                    } else {
                        if (!areJSPClassesAvailable || !(currentTrace instanceof JspException)) break;
                        currentTrace = ((JspException)currentTrace).getRootCause();
                    }
                    if (currentTrace == null) continue;
                    printWriter.println("Caused by:");
                }
                formattedTrace = stringWriter.toString();
            } else if (attribs != null && isObjectDumperAvailable) {
                try {
                    Trace.dumpObjectArgs[0] = trace;
                    Trace.dumpObjectArgs[1] = attribs;
                    formattedTrace = (String)dumpObject.invoke(objectDumper, dumpObjectArgs);
                }
                catch (Exception exc) {
                    Trace.trace("XFRMTRCF: !!!!!!OBJECT DUMP ERROR!!!!!!!!: " + exc);
                    formattedTrace = trace.toString();
                }
            }
            if (formattedTrace == null || formattedTrace.length() == 0) {
                formattedTrace = trace instanceof byte[] ? HexString.toHex((byte[])trace, 4, 16, true) : trace.toString();
            }
            prefix = traceMask.substring(0, 8) + ": " + prefix;
            if (formattedTrace.indexOf(10) != -1 || formattedTrace.length() > 498) {
                StringTokenizer tokenizer = new StringTokenizer(formattedTrace, "\n");
                while (tokenizer.hasMoreTokens()) {
                    String line = tokenizer.nextToken();
                    if (line.length() > 498) {
                        Trace.trace(prefix + line.substring(0, 498) + "...");
                        line = line.substring(498);
                        while (line.length() > 495) {
                            Trace.trace(prefix + "..." + line.substring(0, 495) + "...");
                            line = line.substring(495);
                        }
                        Trace.trace(prefix + "..." + line);
                        continue;
                    }
                    Trace.trace(prefix.concat(line));
                }
            } else {
                Trace.trace(prefix.concat(formattedTrace));
            }
        }
    }

    public static void trace(String traceMask, String prefix, Object trace) {
        Trace.trace(traceMask, prefix, trace, null);
    }

    public static void trace(String traceMask, Object trace, ObjectDumperAttributes attribs) {
        Trace.trace(traceMask, "", trace, attribs);
    }

    public static void trace(String traceMask, Object trace) {
        Trace.trace(traceMask, "", trace, null);
    }

    public static void setDefaultOutput(String filename) {
        printStreamName = filename;
        try {
            printStream = new TracePrintStream(filename);
        }
        catch (SecurityException exc) {}
    }

    static boolean isLibraryLoaded() {
        return isLibraryLoaded;
    }

    private static void trace(String trace) {
        if (isLibraryLoaded) {
            Trace.XjniTrace(trace);
        } else if (printStream != null || printStreamName == STD) {
            System.out.println(trace);
        }
    }

    private static native void XjniTrace(String var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        printStreamName = STD;
        try {
            System.loadLibrary("jniTrace");
            isLibraryLoaded = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Class<?> objectDumperClass = Class.forName("com.ibm.hwmca.fw.util.ObjectDumper");
            objectDumper = objectDumperClass.newInstance();
            Class[] dumpObjectArgTypes = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Trace.class$("java.lang.Object")) : class$java$lang$Object, class$com$ibm$hwmca$fw$util$ObjectDumperAttributes == null ? (class$com$ibm$hwmca$fw$util$ObjectDumperAttributes = Trace.class$("com.ibm.hwmca.fw.util.ObjectDumperAttributes")) : class$com$ibm$hwmca$fw$util$ObjectDumperAttributes};
            dumpObject = objectDumperClass.getMethod("dumpObject", dumpObjectArgTypes);
            isObjectDumperAvailable = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Class.forName("javax.servlet.ServletException");
            areServletClassesAvailable = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName("javax.servlet.jsp.JspException");
            areJSPClassesAvailable = true;
        }
        catch (ClassNotFoundException e) {}
    }
}

